/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.HexDumpFileFilter;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.ui.AppleCommander;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.AppleSingle;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.StreamUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;

public class ac {
    private static TextBundle textBundle = UiBundle.getInstance();

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ac.help();
            } else if ("-i".equalsIgnoreCase(args[0])) {
                ac.getDiskInfo(args);
            } else if ("-ls".equalsIgnoreCase(args[0])) {
                ac.showDirectory(args, 1);
            } else if ("-l".equalsIgnoreCase(args[0])) {
                ac.showDirectory(args, 2);
            } else if ("-ll".equalsIgnoreCase(args[0])) {
                ac.showDirectory(args, 3);
            } else if ("-e".equalsIgnoreCase(args[0])) {
                ac.getFile(args[1], args[2], true, args.length > 3 ? new PrintStream(new FileOutputStream(args[3])) : System.out);
            } else if ("-x".equalsIgnoreCase(args[0])) {
                ac.getFiles(args[1], args.length > 2 ? args[2] : "");
            } else if ("-g".equalsIgnoreCase(args[0])) {
                ac.getFile(args[1], args[2], false, args.length > 3 ? new PrintStream(new FileOutputStream(args[3])) : System.out);
            } else if ("-p".equalsIgnoreCase(args[0])) {
                ac.putFile(args[1], new Name(args[2]), args[3], args.length > 4 ? args[4] : "0x2000");
            } else if ("-d".equalsIgnoreCase(args[0])) {
                ac.deleteFile(args[1], args[2]);
            } else if ("-k".equalsIgnoreCase(args[0])) {
                ac.setFileLocked(args[1], args[2], true);
            } else if ("-u".equalsIgnoreCase(args[0])) {
                ac.setFileLocked(args[1], args[2], false);
            } else if ("-n".equalsIgnoreCase(args[0])) {
                ac.setDiskName(args[1], args[2]);
            } else if ("-cc65".equalsIgnoreCase(args[0])) {
                System.err.println("Note: -cc65 is deprecated.  Please use -as or -dos as appropriate.");
                ac.putDOS(args[1], new Name(args[2]), args[3]);
            } else if ("-dos".equalsIgnoreCase(args[0])) {
                ac.putDOS(args[1], new Name(args[2]), args[3]);
            } else if ("-as".equalsIgnoreCase(args[0])) {
                ac.putAppleSingle(args[1], args.length >= 3 ? args[2] : null);
            } else if ("-geos".equalsIgnoreCase(args[0])) {
                ac.putGEOS(args[1]);
            } else if ("-dos140".equalsIgnoreCase(args[0])) {
                ac.createDosDisk(args[1], 143360);
            } else if ("-pas140".equalsIgnoreCase(args[0])) {
                ac.createPasDisk(args[1], args[2], 143360);
            } else if ("-pas800".equalsIgnoreCase(args[0])) {
                ac.createPasDisk(args[1], args[2], 819200);
            } else if ("-pro140".equalsIgnoreCase(args[0])) {
                ac.createProDisk(args[1], args[2], 143360);
            } else if ("-pro800".equalsIgnoreCase(args[0])) {
                ac.createProDisk(args[1], args[2], 819200);
            } else if ("-convert".equalsIgnoreCase(args[0])) {
                if (args.length > 3) {
                    ac.convert(args[1], args[2], Integer.parseInt(args[3]));
                } else {
                    ac.convert(args[1], args[2]);
                }
            } else {
                ac.help();
            }
        }
        catch (Exception ex) {
            System.err.println(textBundle.format("CommandLineErrorMessage", ex.getLocalizedMessage()));
            ex.printStackTrace();
            ac.help();
        }
    }

    public static void putFile(String fileName, String imageName, String fileOnImageName, String fileType, String address) throws IOException, DiskException {
        Name name = new Name(fileOnImageName);
        File file = new File(fileName);
        if (!file.canRead()) {
            throw new IOException("Unable to read input file named " + fileName + ".");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] inb = new byte[1024];
        int byteCount = 0;
        try (FileInputStream is = new FileInputStream(file);){
            while ((byteCount = ((InputStream)is).read(inb)) > 0) {
                buf.write(inb, 0, byteCount);
            }
            Disk disk = new Disk(imageName);
            FormattedDisk[] formattedDisks = disk.getFormattedDisks();
            FormattedDisk formattedDisk = formattedDisks[0];
            FileEntry entry = name.createEntry(formattedDisk);
            if (entry != null) {
                entry.setFiletype(fileType);
                entry.setFilename(name.name);
                entry.setFileData(buf.toByteArray());
                if (entry.needsAddress()) {
                    entry.setAddress(ac.stringToInt(address));
                }
                formattedDisk.save();
            }
        }
    }

    static void putFile(String imageName, Name name, String fileType, String address) throws IOException, DiskException {
        ac.putFile(imageName, name, fileType, address, System.in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void putFile(String imageName, Name name, String fileType, String address, InputStream inputStream) throws IOException, DiskException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        StreamUtil.copy(inputStream, buf);
        Disk disk = new Disk(imageName);
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        if (formattedDisks == null) {
            System.out.println("Dude, formattedDisks is null!");
        }
        FormattedDisk formattedDisk = formattedDisks[0];
        if (disk.isSDK() || disk.isDC42()) throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        FileEntry entry = name.createEntry(formattedDisk);
        if (entry == null) throw new IOException("Unable to create entry...");
        entry.setFiletype(fileType);
        entry.setFilename(name.name);
        entry.setFileData(buf.toByteArray());
        if (entry.needsAddress()) {
            entry.setAddress(ac.stringToInt(address));
        }
        formattedDisk.save();
    }

    public static void putCC65(String fileName, String imageName, String fileOnImageName, String fileType) throws IOException, DiskException {
        byte[] header = new byte[4];
        if (System.in.read(header, 0, 4) == 4) {
            int address = AppleUtil.getWordValue(header, 0);
            ac.putFile(fileName, imageName, fileOnImageName, fileType, Integer.toString(address));
        }
    }

    static void putDOS(String imageName, Name name, String fileType) throws IOException, DiskException {
        byte[] header = new byte[4];
        if (System.in.read(header, 0, 4) == 4) {
            int address = AppleUtil.getWordValue(header, 0);
            ac.putFile(imageName, name, fileType, Integer.toString(address));
        }
    }

    public static void putAppleSingle(String imageName, String fileName) throws IOException, DiskException {
        ac.putAppleSingle(imageName, fileName, System.in);
    }

    public static void putAppleSingle(String imageName, String fileName, InputStream inputStream) throws IOException, DiskException {
        AppleSingle as = new AppleSingle(inputStream);
        if (fileName == null) {
            fileName = as.getRealName();
        }
        if (fileName == null) {
            throw new IOException("Please specify a file name - this AppleSingle does not have one.");
        }
        if (as.getProdosFileInfo() == null) {
            throw new IOException("This AppleSingle does not contain a ProDOS file.");
        }
        if (as.getDataFork() == null || as.getDataFork().length == 0) {
            throw new IOException("This AppleSingle does not contain a data fork.");
        }
        Name name = new Name(fileName);
        AppleSingle.ProdosFileInfo info = as.getProdosFileInfo();
        String fileType = ProdosFormatDisk.getFiletype(info.getFileType());
        ac.putFile(imageName, name, fileType, Integer.toString(info.getAuxType()), new ByteArrayInputStream(as.getDataFork()));
    }

    static void putGEOS(String imageName) throws IOException, DiskException {
        ac.putFile(imageName, new Name("GEOS-Should Be ProDOS"), "GEO", "0");
    }

    static void deleteFile(String imageName, String fileName) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        Name name = new Name(fileName);
        if (!disk.isSDK() && !disk.isDC42()) {
            FormattedDisk[] formattedDisks = disk.getFormattedDisks();
            for (int i = 0; i < formattedDisks.length; ++i) {
                FormattedDisk formattedDisk = formattedDisks[i];
                FileEntry entry = name.getEntry(formattedDisk);
                if (entry != null) {
                    entry.delete();
                    disk.save();
                    continue;
                }
                System.err.println(textBundle.format("CommandLineNoMatchMessage", name.fullName));
            }
        } else {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
    }

    static void getFile(String imageName, String fileName, boolean filter, PrintStream out) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        Name name = new Name(fileName);
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        if (out == null) {
            out = System.out;
        }
        for (int i = 0; i < formattedDisks.length; ++i) {
            FormattedDisk formattedDisk = formattedDisks[i];
            FileEntry entry = name.getEntry(formattedDisk);
            if (entry != null) {
                if (filter) {
                    FileFilter ff = entry.getSuggestedFilter();
                    if (ff instanceof BinaryFileFilter) {
                        ff = new HexDumpFileFilter();
                    }
                    byte[] buf = ff.filter(entry);
                    out.write(buf, 0, buf.length);
                    continue;
                }
                byte[] buf = entry.getFileData();
                out.write(buf, 0, buf.length);
                continue;
            }
            System.err.println(textBundle.format("CommandLineNoMatchMessage", name.fullName));
        }
    }

    static void getFiles(String imageName, String directory) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        if (directory != null && directory.length() > 0) {
            if (!directory.endsWith(File.separator)) {
                directory = directory + File.separator;
            }
        } else {
            directory = "." + File.separator;
        }
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        for (int i = 0; i < formattedDisks.length; ++i) {
            FormattedDisk formattedDisk = formattedDisks[i];
            ac.writeFiles(formattedDisk.getFiles(), directory);
        }
    }

    static void writeFiles(List<FileEntry> files, String directory) throws IOException, DiskException {
        for (FileEntry entry : files) {
            if (entry != null && !entry.isDeleted() && !entry.isDirectory()) {
                FileFilter ff = entry.getSuggestedFilter();
                if (ff instanceof BinaryFileFilter) {
                    ff = new HexDumpFileFilter();
                }
                byte[] buf = ff.filter(entry);
                String filename = ff.getSuggestedFileName(entry);
                File file = new File(directory + filename);
                File dir = new File(directory);
                dir.mkdirs();
                FileOutputStream output = new FileOutputStream(file);
                ((OutputStream)output).write(buf, 0, buf.length);
                ((OutputStream)output).close();
                continue;
            }
            if (!entry.isDirectory()) continue;
            ac.writeFiles(((DirectoryEntry)((Object)entry)).getFiles(), directory + entry.getFilename() + File.separator);
        }
    }

    static FileEntry getEntry(List<FileEntry> files, String fileName) throws DiskException {
        if (files != null) {
            for (FileEntry entry : files) {
                String entryName = entry.getFilename();
                if (!entry.isDeleted() && fileName.equalsIgnoreCase(entryName)) {
                    return entry;
                }
                if (!entry.isDirectory() || (entry = ac.getEntry(((DirectoryEntry)((Object)entry)).getFiles(), fileName)) == null) continue;
                return entry;
            }
        }
        return null;
    }

    static void showDirectory(String[] args, int display) throws IOException {
        for (int d = 1; d < args.length; ++d) {
            try {
                Disk disk = new Disk(args[d]);
                FormattedDisk[] formattedDisks = disk.getFormattedDisks();
                for (int i = 0; i < formattedDisks.length; ++i) {
                    FormattedDisk formattedDisk = formattedDisks[i];
                    System.out.print(args[d] + " ");
                    System.out.println(formattedDisk.getDiskName());
                    List<FileEntry> files = formattedDisk.getFiles();
                    if (files != null) {
                        ac.showFiles(files, "", display);
                    }
                    System.out.println(textBundle.format("CommandLineStatus", new Object[]{formattedDisk.getFormat(), new Integer(formattedDisk.getFreeSpace()), new Integer(formattedDisk.getUsedSpace())}));
                    System.out.println();
                }
                continue;
            }
            catch (DiskException e) {
                throw new IOException(e);
            }
            catch (RuntimeException e) {
                System.out.println(args[d] + ": " + e.getMessage());
                System.out.println();
            }
        }
    }

    static void showFiles(List<FileEntry> files, String indent, int display) throws DiskException {
        for (FileEntry entry : files) {
            if (!entry.isDeleted()) {
                List<String> data = entry.getFileColumnData(display);
                System.out.print(indent);
                for (int d = 0; d < data.size(); ++d) {
                    System.out.print(data.get(d));
                    System.out.print(" ");
                }
                System.out.println();
            }
            if (!entry.isDirectory()) continue;
            ac.showFiles(((DirectoryEntry)((Object)entry)).getFiles(), indent + "  ", display);
        }
    }

    static void getDiskInfo(String[] args) throws IOException, DiskException {
        for (int d = 1; d < args.length; ++d) {
            Disk disk = new Disk(args[d]);
            FormattedDisk[] formattedDisks = disk.getFormattedDisks();
            for (int i = 0; i < formattedDisks.length; ++i) {
                FormattedDisk formattedDisk = formattedDisks[i];
                for (FormattedDisk.DiskInformation diskinfo : formattedDisk.getDiskInformation()) {
                    System.out.println(diskinfo.getLabel() + ": " + diskinfo.getValue());
                }
            }
            System.out.println();
        }
    }

    public static void setFileLocked(String imageName, String name, boolean lockState) throws IOException, DiskException {
        ac.setFileLocked(imageName, new Name(name), lockState);
    }

    static void setFileLocked(String imageName, Name name, boolean lockState) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        if (!disk.isSDK() && !disk.isDC42()) {
            FormattedDisk[] formattedDisks = disk.getFormattedDisks();
            for (int i = 0; i < formattedDisks.length; ++i) {
                FormattedDisk formattedDisk = formattedDisks[i];
                FileEntry entry = name.getEntry(formattedDisk);
                if (entry != null) {
                    entry.setLocked(lockState);
                    disk.save();
                    continue;
                }
                System.err.println(textBundle.format("CommandLineNoMatchMessage", name.fullName));
            }
        } else {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
    }

    public static void setDiskName(String imageName, String volName) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        if (disk.isSDK() || disk.isDC42()) {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        FormattedDisk formattedDisk = formattedDisks[0];
        formattedDisk.setDiskName(volName);
        formattedDisks[0].save();
    }

    public static void createDosDisk(String fileName, int imageSize) throws IOException {
        ByteArrayImageLayout layout = new ByteArrayImageLayout(imageSize);
        DosOrder imageOrder = new DosOrder(layout);
        DosFormatDisk[] disks = DosFormatDisk.create(fileName, imageOrder);
        disks[0].save();
    }

    public static void createPasDisk(String fileName, String volName, int imageSize) throws IOException {
        ByteArrayImageLayout layout = new ByteArrayImageLayout(imageSize);
        ProdosOrder imageOrder = new ProdosOrder(layout);
        PascalFormatDisk[] disks = PascalFormatDisk.create(fileName, volName, imageOrder);
        disks[0].save();
    }

    public static void createProDisk(String fileName, String volName, int imageSize) throws IOException {
        ByteArrayImageLayout layout = new ByteArrayImageLayout(imageSize);
        ProdosOrder imageOrder = new ProdosOrder(layout);
        ProdosFormatDisk[] disks = ProdosFormatDisk.create(fileName, volName, imageOrder);
        disks[0].save();
    }

    static void convert(String shrinkName, String imageName) throws IOException {
        ac.convert(shrinkName, imageName, 0);
    }

    static void convert(String shrinkName, String imageName, int imageSize) throws IOException {
        Disk disk = new Disk(shrinkName, imageSize);
        disk.setFilename(imageName);
        disk.save();
    }

    static int stringToInt(String s) {
        int i = 0;
        try {
            s = s.trim().toLowerCase();
            i = s.startsWith("$") ? Integer.parseInt(s.substring(1), 16) : (s.startsWith("0x") ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s));
        }
        catch (NumberFormatException nfe) {
            i = 8192;
        }
        return i;
    }

    static void help() {
        System.err.println(textBundle.format("CommandLineHelp", AppleCommander.VERSION));
    }

    public static class Name {
        private String fullName;
        private String name;
        private String[] path;

        public Name(String s) {
            this.fullName = s;
            if (s.startsWith("/")) {
                this.fullName = s.substring(1, s.length());
            }
            this.path = s.split("/");
            this.name = this.path[this.path.length - 1];
        }

        public FileEntry getEntry(FormattedDisk formattedDisk) throws DiskException {
            int i;
            List<FileEntry> files = formattedDisk.getFiles();
            FileEntry entry = null;
            for (i = 0; i < this.path.length - 1; ++i) {
                String dirName = this.path[i];
                for (int j = 0; j < files.size(); ++j) {
                    entry = files.get(j);
                    String entryName = entry.getFilename();
                    if (!entry.isDirectory() || !dirName.equalsIgnoreCase(entryName)) continue;
                    files = ((DirectoryEntry)((Object)entry)).getFiles();
                }
            }
            for (i = 0; i < files.size(); ++i) {
                entry = files.get(i);
                String entryName = entry.getFilename();
                if (entry.isDeleted() || !this.name.equalsIgnoreCase(entryName)) continue;
                return entry;
            }
            return null;
        }

        public FileEntry createEntry(FormattedDisk formattedDisk) throws DiskException {
            if (this.path.length == 1) {
                return formattedDisk.createFile();
            }
            List<FileEntry> files = formattedDisk.getFiles();
            DirectoryEntry dir = null;
            DirectoryEntry parentDir = null;
            for (int i = 0; i < this.path.length - 1; ++i) {
                String dirName = this.path[i];
                dir = null;
                for (int j = 0; j < files.size(); ++j) {
                    FileEntry entry = files.get(j);
                    String entryName = entry.getFilename();
                    if (entry.isDeleted() || !entry.isDirectory() || !dirName.equalsIgnoreCase(entryName)) continue;
                    parentDir = dir = (DirectoryEntry)((Object)entry);
                    files = dir.getFiles();
                }
                if (dir != null) continue;
                parentDir = parentDir != null ? (dir = parentDir.createDirectory(dirName)) : (dir = formattedDisk.createDirectory(dirName));
            }
            if (dir != null) {
                return dir.createFile();
            }
            System.err.println(textBundle.format("CommandLineNoMatchMessage", this.fullName));
            return null;
        }
    }
}

